package GUI;

import java.awt.Color;
import java.awt.ComponentOrientation;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;

import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;

import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import javax.swing.SpringLayout;

import jhe.hexed.JHexEditor;

import FlashReader.DoABC;
import FlashReader.SWF;
import FlashReader.Tag;

public class GUI_Tag extends JInternalFrame {

	private JTextArea instruction_ta;
	private JTextField pozycja_tf;
	private JComboBox opCodes;
	private JTextField op_tf;
	private JComboBox TagsComboBox;
	private SWF swf;
	private Tag selectedTag;
	private GUIswfReader gui;
	private byte date[];
	
	public GUI_Tag(final SWF swf, final GUIswfReader gui) {
		super("Tag editor",
		          false, //resizable
		          true, //closable
		          false, //maximizable
		          true);//iconifiable
		setSize(778, 548);
		setResizable(false);
		this.swf = swf;
		this.gui = gui;
		op_tf = new JTextField();
		op_tf.addActionListener(new ActionListener() {
			public void actionPerformed(final ActionEvent e) {
				selectedTag.setopcode(Integer.parseInt(op_tf.getText()));
			}
		});
		pozycja_tf = new JTextField();
		TagsComboBox = new JComboBox();
		TagsComboBox.addActionListener(new ActionListener() {
			public void actionPerformed(final ActionEvent e) {
				selectedTag = (Tag) TagsComboBox.getSelectedItem();
				if(selectedTag!=null){
					op_tf.setText(selectedTag.getopcode()+"");
					pozycja_tf.setText(SWF.EN_Tag.indexOf(selectedTag)+"");
					date = selectedTag.getDate().array();
					
				}
			}
		});
		
		
		JLabel tagLabel;
		tagLabel = new JLabel();
		tagLabel.setText("Tag");

		
		JPanel panel;
		panel = new JPanel();
		panel.setBackground(Color.ORANGE);

		JButton addButton;
		addButton = new JButton();
		addButton.addActionListener(new ActionListener() {
			public void actionPerformed(final ActionEvent arg0) {
				
				if (Integer.parseInt(op_tf.getText())== 0x72 || Integer.parseInt(op_tf.getText())== 0x82  ){
					new DoABC(Integer.parseInt(pozycja_tf.getText()),Integer.parseInt(op_tf.getText()),date,swf,true);
				}else{
					new Tag(Integer.parseInt(pozycja_tf.getText()),Integer.parseInt(op_tf.getText()),date,swf,true);

				}
			
				gui.showInfo(SWF.msgs.getString("ok"));
				init();
			}
		});
		addButton.setText("Add");
		addButton.setText(SWF.msgs.getString("add"));
		
		
		JButton removeButton;
		removeButton = new JButton();
		removeButton.addActionListener(new ActionListener() {
			public void actionPerformed(final ActionEvent e) {
				SWF.EN_Tag.remove(selectedTag);

				init();
			}
		});
		removeButton.setText("Remove");
		removeButton.setText(SWF.msgs.getString("remove"));

		JLabel opLabel;
		opLabel = new JLabel();
		opLabel.setText("OP");

		final JFileChooser fc2 = new JFileChooser();
		
		fc2.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
			    //Handle open button action.
			    if (e.getSource() == fc2) {
			    	String returnVal = e.getActionCommand();
			    	if (returnVal.equals(JFileChooser.APPROVE_SELECTION)) {
			    		
			    		File file = fc2.getSelectedFile();
			    		
			    		try{
			    			FileOutputStream f = new FileOutputStream(file);
			    			DataOutputStream out = new DataOutputStream(f);
			    			out.write(selectedTag.getDate().array());
			    			out.close();

			    		}catch(Exception ex){
			    			ex.printStackTrace();
			    		}
			    	}
			   } 
			}
			});

		final JFileChooser fc = new JFileChooser();
		fc.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
			    //Handle open button action.
			    if (e.getSource() == fc) {
			    	try {
			    	String returnVal = e.getActionCommand();
			    	if (returnVal.equals(JFileChooser.APPROVE_SELECTION)) {
			    		File file = fc.getSelectedFile();
			    		gui.showInfo(SWF.msgs.getString("chooseFile"));
			    		FileInputStream f = new FileInputStream(file);
			    		DataInputStream in = new DataInputStream(f);
			    		byte b[] = new byte[in.available()];
						in.readFully(b);
						date = b;
						
			    	}
			    } catch(Exception ex){
			    		ex.printStackTrace();
			    }
						
			    
			    	
			   } 
			
			}
			});
		instruction_ta = new JTextArea();
		instruction_ta.setLineWrap(true);
		JButton daneButton;
		daneButton = new JButton();
		daneButton.addActionListener(new ActionListener() {
			public void actionPerformed(final ActionEvent arg0) {
				fc.showOpenDialog(gui.frame);
			}
		});
		daneButton.setText("Dane");
		opCodes = new JComboBox();
		opCodes.addActionListener(new ActionListener() {
			public void actionPerformed(final ActionEvent e) {
				instruction_ta.setText(SWF.msgs.getString("instructions"));
			}
		});
		
		
		for (Integer i :SWF.tags.keySet()  ){
			opCodes.addItem(i + " - " + SWF.tags.get(i) );
		}
		
		JLabel pozycjaLabel;
		pozycjaLabel = new JLabel();
		pozycjaLabel.setText("Position ID");

		JButton hexviewButton;
		hexviewButton = new JButton();
		hexviewButton.addActionListener(new ActionListener() {
			public void actionPerformed(final ActionEvent e) {
				JHexEditor jhe = new JHexEditor(selectedTag.getDate().array());
				gui.frame.getContentPane().add(jhe);
				jhe.setVisible(true);
				jhe.toFront();
			}
		});
		hexviewButton.setText("HexView");

		
		

		JLabel infoToolLabel;
		infoToolLabel = new JLabel();
		infoToolLabel.setText("Info tool");

		JScrollPane scrollPane;
		scrollPane = new JScrollPane();
		scrollPane.setViewportView(instruction_ta);

		JButton saveDaneButton;
		saveDaneButton = new JButton();
		saveDaneButton.addActionListener(new ActionListener() {
			public void actionPerformed(final ActionEvent arg0) {
				fc2.showSaveDialog(gui.getFrame());
			}
		});
		saveDaneButton.setText("Save");
		saveDaneButton.setText(SWF.msgs.getString("save"));

		JButton replaceButton;
		replaceButton = new JButton();
		replaceButton.addActionListener(new ActionListener() {
			public void actionPerformed(final ActionEvent arg0) {
				if (Integer.parseInt(op_tf.getText())== 0x72 || Integer.parseInt(op_tf.getText())== 0x82  ){
					DoABC doABC = (DoABC)selectedTag;
					doABC.setDate(date);
					doABC.setopcode(Integer.parseInt(op_tf.getText()));
				}else{
					Tag t = selectedTag;
					t.setDate(date);
					t.setopcode(Integer.parseInt(op_tf.getText()));
				}

			}
		});
		replaceButton.setText("Replace");
		replaceButton.setText(SWF.msgs.getString("replace"));
		final GroupLayout groupLayout_2 = new GroupLayout((JComponent) panel);
		groupLayout_2.setHorizontalGroup(
			groupLayout_2.createParallelGroup(GroupLayout.Alignment.LEADING)
				.addGroup(groupLayout_2.createSequentialGroup()
					.addContainerGap()
					.addComponent(tagLabel)
					.addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)
					.addComponent(addButton, GroupLayout.PREFERRED_SIZE, 80, GroupLayout.PREFERRED_SIZE)
					.addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)
					.addComponent(removeButton, GroupLayout.PREFERRED_SIZE, 80, GroupLayout.PREFERRED_SIZE)
					.addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)
					.addComponent(replaceButton)
					.addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 61, Short.MAX_VALUE)
					.addComponent(TagsComboBox, GroupLayout.PREFERRED_SIZE, 374, GroupLayout.PREFERRED_SIZE)
					.addContainerGap())
		);
		groupLayout_2.setVerticalGroup(
			groupLayout_2.createParallelGroup(GroupLayout.Alignment.LEADING)
				.addGroup(groupLayout_2.createSequentialGroup()
					.addGroup(groupLayout_2.createParallelGroup(GroupLayout.Alignment.LEADING)
						.addGroup(groupLayout_2.createSequentialGroup()
							.addGap(9, 9, 9)
							.addComponent(tagLabel))
						.addGroup(groupLayout_2.createSequentialGroup()
							.addGap(4, 4, 4)
							.addGroup(groupLayout_2.createParallelGroup(GroupLayout.Alignment.BASELINE)
								.addComponent(addButton)
								.addComponent(removeButton)
								.addComponent(replaceButton)
								.addComponent(TagsComboBox, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE))))
					.addContainerGap(GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
		);
		panel.setLayout(groupLayout_2);

		

		
		final GroupLayout groupLayout = new GroupLayout((JComponent) getContentPane());
		groupLayout.setHorizontalGroup(
			groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING)
				.addGroup(groupLayout.createSequentialGroup()
					.addContainerGap()
					.addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING)
						.addComponent(scrollPane)
						.addComponent(panel, GroupLayout.Alignment.TRAILING, GroupLayout.DEFAULT_SIZE, 744, Short.MAX_VALUE)
						.addGroup(groupLayout.createSequentialGroup()
							.addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING)
								.addComponent(pozycjaLabel)
								.addComponent(opLabel))
							.addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)
							.addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING)
								.addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false)
									.addComponent(op_tf)
									.addComponent(pozycja_tf, GroupLayout.DEFAULT_SIZE, 178, Short.MAX_VALUE))
								.addGroup(groupLayout.createSequentialGroup()
									.addComponent(hexviewButton, GroupLayout.PREFERRED_SIZE, 128, GroupLayout.PREFERRED_SIZE)
									.addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)
									.addComponent(saveDaneButton, GroupLayout.PREFERRED_SIZE, 112, GroupLayout.PREFERRED_SIZE)
									.addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)
									.addComponent(daneButton, GroupLayout.PREFERRED_SIZE, 128, GroupLayout.PREFERRED_SIZE))))
						.addGroup(groupLayout.createSequentialGroup()
							.addComponent(infoToolLabel)
							.addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 442, Short.MAX_VALUE)
							.addComponent(opCodes, GroupLayout.PREFERRED_SIZE, 257, GroupLayout.PREFERRED_SIZE)))
					.addContainerGap())
		);
		groupLayout.setVerticalGroup(
			groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING)
				.addGroup(groupLayout.createSequentialGroup()
					.addContainerGap()
					.addComponent(panel, GroupLayout.PREFERRED_SIZE, 34, GroupLayout.PREFERRED_SIZE)
					.addGap(34, 34, 34)
					.addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE)
						.addComponent(op_tf, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE)
						.addComponent(opLabel))
					.addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)
					.addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE)
						.addComponent(hexviewButton)
						.addComponent(saveDaneButton)
						.addComponent(daneButton))
					.addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)
					.addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING)
						.addGroup(groupLayout.createSequentialGroup()
							.addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE)
								.addComponent(pozycja_tf, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE)
								.addComponent(pozycjaLabel))
							.addGap(37, 37, 37)
							.addComponent(infoToolLabel))
						.addComponent(opCodes, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE))
					.addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)
					.addComponent(scrollPane, GroupLayout.DEFAULT_SIZE, 286, Short.MAX_VALUE)
					.addContainerGap())
		);
		groupLayout.linkSize(javax.swing.SwingConstants.VERTICAL, new java.awt.Component[] {daneButton, hexviewButton, saveDaneButton});
		getContentPane().setLayout(groupLayout);
		//
		init();
	}
	
	private void init(){
		TagsComboBox.removeAllItems();
		for ( Tag t : SWF.EN_Tag){
			TagsComboBox.addItem(t);
		}
	}
	
	
}
